#version 330

#if VTF_TRANSFORM
	uniform sampler1D transformMap;
#else
	#ifndef INSTANCED
		uniform mat4 world;
	#endif
#endif

#if ANIM
uniform vec4 worldMatrix3x4Array[144];
uniform float numBones;
#endif

in vec4 vertex;
#if INSTANCED_BOX
	in vec4 uv0; //Offset and transform index
	in vec4 uv1; //Scale and material index
#else
	#if INSTANCED
		in vec4 uv0; //uv
		#if ONE_POSE_ANIMATION
			in vec4 uv1; //Vertex animation pose data
			in vec4 uv2; //world0
			in vec4 uv3; //world1
			in vec4 uv4; //world2
			in vec4 uv5; //x: animation weight, y: 0, z: 0, w: color index and texture index
		#else
			in vec4 uv1; //world0
			in vec4 uv2; //world1
			in vec4 uv3; //world2
		#endif
	#else
		in vec4 uv0; //uv
	#endif
#endif

#if ANIM
in vec4 blendWeights;
in vec4 blendIndices;
#endif

out vec4 depthUv;

uniform mat4 viewproj;
uniform vec4 texelOffsets;
uniform vec4 depthRange;

void main()
{
#if VTF_TRANSFORM
	#if INSTANCED_BOX
		int fetchBase = int(3*uv0.w + 0.5);
	#else
		int fetchBase = int(3*uv0.z + 0.5);
	#endif
	mat3x4 worldT;
	worldT[0] = texelFetch(transformMap, fetchBase, 0);
	worldT[1] = texelFetch(transformMap, fetchBase + 1, 0);
	worldT[2] = texelFetch(transformMap, fetchBase + 2, 0);
	#if INSTANCED_BOX
		vec4 vert = vec4(vertex.xyz*uv1.xyz + uv0.xyz, 1.0);
		vec4 worldPos = vec4(vert * worldT, 1);
	#else
		vec4 worldPos = vec4(vertex * worldT, 1);
	#endif
#else
	#if INSTANCED
		mat3x4 worldT;
		#if ONE_POSE_ANIMATION
			worldT[0] = uv2;
			worldT[1] = uv3;
			worldT[2] = uv4;
			vec4 worldPos = vec4(vec4(uv1.xyz*uv5.x + vertex.xyz, 1.0) * worldT, 1.0);
		#else
			worldT[0] = uv1;
			worldT[1] = uv2;
			worldT[2] = uv3;
			vec4 worldPos = vec4(vertex * worldT, 1.0);
		#endif
	#else
	
		#if ANIM
			vec4 worldPos = vec4(0.0, 0.0, 0.0, 1.0);

			for (int i = 0; i < int(numBones); i++)
			{
				int idx = int(blendIndices[i]) * 3;
				float weight = blendWeights[i];
		
				mat4 worldMatrix;
				worldMatrix[0] = worldMatrix3x4Array[idx];
				worldMatrix[1] = worldMatrix3x4Array[idx + 1];
				worldMatrix[2] = worldMatrix3x4Array[idx + 2];
				worldMatrix[3] = vec4(0.0, 0.0, 0.0, 1.0);
		
				worldPos.xyz += weight * (vertex * worldMatrix).xyz;
			}
	
		#else

			vec4 worldPos = world * vertex;
	
		#endif

	#endif
#endif
	vec4 clipPos = viewproj * worldPos;
    clipPos.xy += texelOffsets.zw * clipPos.w;
	float depth = clipPos.z * 0.5 + 0.5;
	//float depth = clipPos.z;
#if UV
	float difIdx = uv0.w;
	float asgIdx = floor(difIdx/65536 + 0.5);
	difIdx -= asgIdx*65536;
	float norIdx = floor(difIdx/256 + 0.5);
	difIdx -= norIdx*256;
	
	#if ASG
		depthUv = vec4(depth, vec3(uv0.xy, asgIdx));
	#else
		depthUv = vec4(depth, vec3(uv0.xy, difIdx));
	#endif
#else
    depthUv = vec4(depth, 0, 0, 0);
#endif
	gl_Position = clipPos;
}
